import java.awt.*;
import java.awt.event.*;


public class MailerDialog extends Dialog {
    java.awt.Label canvas1;
    java.awt.Label label1;
    java.awt.Label label2;
    java.awt.Label label3;
    java.awt.Label label4;
    java.awt.Label label5;
    CheckboxGroup Group1;
    java.awt.Checkbox radioButton1;
    java.awt.Checkbox radioButton2;
    java.awt.Checkbox radioButton3;
    java.awt.TextField textField1;
    java.awt.TextArea textArea1;
    java.awt.Label label6;
    java.awt.Button sendButton;

    // Used for addNotify check.
    boolean fComponentsAdjusted = false;
    
    // application specific variables
    private boolean flip = true;
    private SMTPSender mailer = new SMTPSender();
    private UserDatabase users;
    private int userIndex;
    private static final String SUBJECT = "unidentified object";
    private static final String VLIST = "General List";
    private static final String VLISTP = "Priviledged List";
    private static final String ADMIN = "Administrator";

    public MailerDialog(Frame parent, boolean modal, UserDatabase users, int userIndex, String title) {
        super(parent, modal);

        setLayout(null);
        setVisible(false);
        setSize(440,420);
        setFont(new Font("Dialog", Font.PLAIN, 12));
        setForeground(new Color(0));
        setBackground(new Color(65280));
        canvas1 = new java.awt.Label("Mail Pad",Label.CENTER);
        canvas1.setBounds(20,9,402,50);
        canvas1.setFont(new Font("Dialog", Font.PLAIN, 20));
        canvas1.setForeground(new Color(16711680));
        add(canvas1);
        label1 = new java.awt.Label("From:");
        label1.setBounds(13,69,101,25);
        label1.setFont(new Font("Dialog", Font.BOLD, 16));
        label1.setForeground(new Color(255));
        add(label1);
        label2 = new java.awt.Label("To:");
        label2.setBounds(13,96,101,25);
        label2.setFont(new Font("Dialog", Font.BOLD, 16));
        label2.setForeground(new Color(255));
        add(label2);
        label3 = new java.awt.Label("Subject:");
        label3.setBounds(13,165,101,25);
        label3.setFont(new Font("Dialog", Font.BOLD, 16));
        label3.setForeground(new Color(255));
        add(label3);
        label4 = new java.awt.Label("Message:");
        label4.setBounds(13,190,101,25);
        label4.setFont(new Font("Dialog", Font.BOLD, 16));
        label4.setForeground(new Color(255));
        add(label4);
        label5 = new java.awt.Label(users.getEmail(userIndex));
        label5.setBounds(131,69,296,25);
        label5.setFont(new Font("Dialog", Font.PLAIN, 14));
        add(label5);
        Group1 = new CheckboxGroup();
        radioButton1 = new java.awt.Checkbox(VLIST, Group1, true);
        radioButton1.setBounds(131,96,144,24);
        radioButton1.setFont(new Font("Dialog", Font.PLAIN, 14));
        add(radioButton1);
        radioButton2 = new java.awt.Checkbox(VLISTP, Group1, false);
        radioButton2.setBounds(283,96,144,24);
        radioButton2.setFont(new Font("Dialog", Font.PLAIN, 14));
        if (users.getLevel(userIndex) < PriviledgeLevel.PL_PRIVILEDGED) {
            radioButton2.setVisible(false);
        }
        add(radioButton2);
        radioButton3 = new java.awt.Checkbox(ADMIN, Group1, false);
        radioButton3.setBounds(131,123,144,24);
        radioButton3.setFont(new Font("Dialog", Font.PLAIN, 14));
        add(radioButton3);
        textField1 = new java.awt.TextField(SUBJECT);
        textField1.setBounds(131,165,296,25);
        textField1.setFont(new Font("Dialog", Font.PLAIN, 14));
        textField1.setBackground(new Color(16777215));
        add(textField1);
        textArea1 = new java.awt.TextArea();
        textArea1.setBounds(15,218,412,143);
        textArea1.setFont(new Font("Dialog", Font.PLAIN, 14));
        textArea1.setBackground(new Color(16777215));
        add(textArea1);
        label6 = new java.awt.Label("");
        label6.setBounds(30,368,263,30);
        label6.setFont(new Font("Dialog", Font.BOLD, 16));
        label6.setForeground(new Color(16711680));
        label6.setBackground(new Color(65280));
        add(label6);
        sendButton = new java.awt.Button();
        sendButton.setLabel("Send");
        sendButton.setBounds(318,371,79,27);
        sendButton.setFont(new Font("Dialog", Font.BOLD, 16));
        sendButton.setForeground(new Color(255));
        sendButton.setBackground(new Color(16762880));
        add(sendButton);
        setTitle(title);

        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        sendButton.addActionListener(lSymAction);
        
        mailer.setHost("shrike.depaul.edu");
        this.users = users;
        this.userIndex = userIndex;
    }

    public MailerDialog(Frame parent, boolean modal, UserDatabase users, int userIndex) {
        this(parent, modal, users, userIndex, "Mail");
    }

    public void addNotify() {
        // Record the size of the window prior to calling parents addNotify.
        Dimension d = getSize();
        
        super.addNotify();

        // Only do this once.
        if (fComponentsAdjusted) return;

        // Adjust components according to the insets
        setSize(insets().left + insets().right + d.width, insets().top + insets().bottom + d.height);
        Component components[] = getComponents();
        for (int i = 0; i < components.length; i++) {
            Point p = components[i].getLocation();
            p.translate(insets().left, insets().top);
            components[i].setLocation(p);
        }

        // Used for addNotify check.
        fComponentsAdjusted = true;
    }

    public void setVisible(boolean b) {
        if(b) {
            Rectangle bounds = getParent().getBounds();
            Rectangle abounds = getBounds();
    
            int locx = bounds.x + (bounds.width - abounds.width) / 2;
            int locy = bounds.y + (bounds.height - abounds.height) / 2;
            if (locx < 0) locx = 20;
            if (locy < 0) locy = 20;
            setLocation(locx, locy);
        }
        super.setVisible(b);
    }

    class SymWindow extends java.awt.event.WindowAdapter {
        public void windowClosing(java.awt.event.WindowEvent event) {
            Object object = event.getSource();
            if (object == MailerDialog.this) {
                MailerDialog_WindowClosing(event);
            }
        }
    }

    void MailerDialog_WindowClosing(java.awt.event.WindowEvent event) {
        dispose();
    }

    class SymAction implements java.awt.event.ActionListener {
        public void actionPerformed(java.awt.event.ActionEvent event) {
            Object object = event.getSource();
            if (object == sendButton) {
                sendButton_Clicked(event);
            }
        }
    }

    void sendButton_Clicked(java.awt.event.ActionEvent event) {
        if (flip) {
            String msgBody = textArea1.getText();
            if (msgBody.equals("")) return;
            
            radioButton1.setEnabled(false);
            radioButton2.setEnabled(false);
            radioButton3.setEnabled(false);
            textField1.setEnabled(false);
            textArea1.setEnabled(false);
            sendButton.setEnabled(false);
            
            String msgSubj = textField1.getText();
            String msgTo = Group1.getCurrent().getLabel();
            String msgFrom = label5.getText();
            send(msgBody, msgSubj, msgTo, msgFrom);
            
            sendButton.setLabel("Okay");
            sendButton.setEnabled(true);
        } else {
            radioButton1.setEnabled(true);
            radioButton2.setEnabled(true);
            radioButton3.setEnabled(true);
            textField1.setEnabled(true);
            textField1.setText("unidentified object");
            textArea1.setEnabled(true);
            textArea1.setText("");
            sendButton.setLabel("Send");
            label6.setText("                                ");
        }
        flip = !flip;
    }
    
    private void send(String msgBody, String msgSubj, String msgTo, String msgFrom) {
        int listPriviledge;
        
        label6.setText("Processing...                   ");
        if (msgSubj.equals("")) {
            msgSubj = SUBJECT;
        }
        if (msgTo.equals(VLIST)) {
            msgSubj = "[VLIST] " + msgSubj;
            listPriviledge = PriviledgeLevel.PL_STANDARD;
        } else if (msgTo.equals(VLISTP)) {
            msgSubj = "[VLIST(p)] " + msgSubj;
            listPriviledge = PriviledgeLevel.PL_PRIVILEDGED;
        } else if (msgTo.equals(ADMIN)) {
            msgSubj = "<VLIST> " + msgSubj;
            listPriviledge = PriviledgeLevel.PL_SUPER;
        } else {
            return;
        }
        
        for (int i = 0; i < users.size(); i++) {
            if (users.getLevel(i) >= listPriviledge) {
                String msgTo1 = users.getEmail(i);
                if (!msgTo1.equals("")) {
                    mailer.sendMail(msgTo1, msgFrom, msgSubj, msgBody, null);
                }
            }
            int percentage = i * 100 / users.size();
            label6.setText("Mailing...  " + percentage + "%");
        }
        label6.setText("Mail sent!                      ");
    }
}
