import java.util.*;
import java.io.*;
import java.net.*;
import java.sql.*;


public class PrimaryServerThread extends Thread
        implements ServerCommon, DBCommon {
    protected ShopList shops;
    protected Shop shop;
    protected Socket s;

    public PrimaryServerThread(ShopList shops, Socket s) {
        this.shops = shops;
        this.s = s;
    }

    public void run() {
        try {
            InputStream is = s.getInputStream();
	        BufferedReader in = new BufferedReader(new InputStreamReader(is));
            OutputStream os = s.getOutputStream();
            PrintWriter out = new PrintWriter(new OutputStreamWriter(os));
            System.out.println("\nconnected...");

            boolean success = toAccessDatabase(in);

            if (success) {
    	        String line;
                try {
        	        while ((line = in.readLine()) == null);
                    System.out.println(line);
                    if (line.equals("get category")) {
                        toGetCategory(in, out);
                    } else if (line.equals("get list")) {
                        toGetList(in, out, is, os);
                    } else {
                        out.println("unrecognized command");
            	        out.flush();
                    }
                } catch (Exception e) {
                    System.out.println("Thread " + e.getMessage());
                }
            }

		    in.close();
	        out.close();
    	    s.close();
            System.out.println("disconnected!!!");
        } catch (Exception e) {
            System.out.println("Thread " + e.getMessage());
        }
    }

    private boolean toAccessDatabase(BufferedReader in) {
        boolean success = true;
        try {
            String database;
            while ((database = in.readLine()) == null);
            shop = shops.retrieveShop(database);
        } catch (Exception e) {
            System.out.println("Thread cannot retrieve shop database");
            success = false;
        }
        return success;
    }

    private boolean toGetCategory(BufferedReader in, PrintWriter out) {
        boolean success = true;
        try {
            Vector categoryName = getCategory();
            for (int i = 0; i < categoryName.size(); i++)
                out.println(categoryName.elementAt(i));
            out.println("the end");
	        out.flush();
        } catch (Exception e) {
            success = false;
        }
        return success;
    }

    private boolean toGetList(BufferedReader in, PrintWriter out,
                              InputStream is, OutputStream os) {
        boolean success = true;
        try {
            String category;
            while ((category = in.readLine()) == null);
            Vector products = getProduct(category);
            out.println(String.valueOf(products.size()));
	        out.flush();
            ObjectOutputStream oo = new ObjectOutputStream(os);
            for (int i = 0; i < products.size(); i++) {
                Product product = (Product)products.elementAt(i);
                product.writeObject(oo);
                String line;
                while ((line = in.readLine()) == null);
            }
        } catch (Exception e) {
            success = false;
        }
        return success;
    }

    private Vector getCategory() {
        Vector categoryName = new Vector();
    	try {
            Class.forName("symantec.itools.db.jdbc.Driver");
            String databaseName = shop.getShop();
            String databaseTableName = shop.getProductTable();
            Connection dbConnection = DriverManager.getConnection(
                    "jdbc:dbaw://" + dbServerHost + ":" + dbServerPort
                    + "/MS_Access/" + databaseName + "/" + databaseName);
            try {
                String databaseOperation
                        = "SELECT Category FROM " + databaseTableName
                        + " WHERE "
                        + "Valid = 1";
                Statement sqlStatement = dbConnection.createStatement();
                ResultSet queryResult
                        = sqlStatement.executeQuery(databaseOperation);
                while (queryResult.next()) {
                    String category = queryResult.getString(1);
                    if (!categoryName.contains(category))
                        categoryName.addElement(category);
                }
            } catch (Exception e) {
            }
            dbConnection.close();
        } catch (Exception e) {
        }
        return categoryName;
    }

    private Vector getProduct(String category) {
        Vector products = new Vector();
    	try {
            Class.forName("symantec.itools.db.jdbc.Driver");
            String databaseName = shop.getShop();
            String databaseTableName = shop.getProductTable();
            Connection dbConnection = DriverManager.getConnection(
                    "jdbc:dbaw://" + dbServerHost + ":" + dbServerPort
                    + "/MS_Access/" + databaseName + "/" + databaseName);
            try {
                String databaseOperation
                        = "SELECT Identification, Item, Category"
                        + " FROM " + databaseTableName
                        + " WHERE "
                        + "Valid = 1 and "
                        + "Category = "
                        + convertString(category);
                Statement sqlStatement = dbConnection.createStatement();
                ResultSet queryResult
                        = sqlStatement.executeQuery(databaseOperation);
                while (queryResult.next()) {
                    Product product = new Product();
                    product.setID(queryResult.getString(1));
                    product.setItem(queryResult.getString(2));
                    product.setCategory(queryResult.getString(3));
                    boolean existing = false;
                    for (int i = 0; i < products.size(); i++) {
                        Product thisProduct = (Product)products.elementAt(i);
                        if (thisProduct.getID().equals(product.getID()))
                            existing = true;
                    }
                    if (!existing)
                        products.addElement(product);
                }
            } catch (Exception e) {
            }
            dbConnection.close();
        } catch (Exception e) {
        }
        return products;
    }

    private String convertString(String s) {
        if (s == null)
            return "null";
        else if (s.equals(""))
            return "null";
        else
            return "'" + s + "'";
    }
}
