import java.net.*;
import java.sql.*;


public class PrimaryServer implements ServerCommon, DBCommon {
    protected ShopList shops = new ShopList();
    protected ServerSocket ss;

    public PrimaryServer() {
        try {
            Class.forName("symantec.itools.db.jdbc.Driver");
            Connection dbConnection;
            dbConnection = DriverManager.getConnection(
                    "jdbc:dbaw://" + dbServerHost + ":" + dbServerPort
                    + "/MS_Access/" + masterDB + "/" + masterDB);
            try {
                String databaseOperation
                        = "SELECT Identification, ShopDatabase, ProductTable"
                        + " FROM " + masterDBTable;
                Statement sqlStatement = dbConnection.createStatement();
                ResultSet queryResult
                        = sqlStatement.executeQuery(databaseOperation);
                while (queryResult.next()) {
                    shops.addShop(new Shop(queryResult.getString(1),
                                           queryResult.getString(2),
                                           queryResult.getString(3)));
                }
            } catch (Exception e) {
                System.out.println("DBServer " + e.getMessage());
            }
            dbConnection.close();
        } catch (Exception e) {
            System.out.println("DBServer " + e.getMessage());
        }

        try {
            ss = new ServerSocket(serverPort);
        } catch (Exception e) {
            System.out.println("Server " + e.getMessage());
        }
    }

    public void begin() {
        while (true) {
            try {
                Socket s = ss.accept();
                PrimaryServerThread connection
                        = new PrimaryServerThread(shops, s);
                connection.start();
            } catch (Exception e) {
                System.out.println("Server " + e.getMessage());
            }
        }
    }
}
