import java.io.*;
import java.util.*;


public class LoadedCategories {
    protected Vector categories = new Vector();
    protected String currentCategoryName = "";
    protected int currentCategory = -1;

    public void toRedraw() {
        currentCategoryName = "";
        currentCategory = -1;
    }
    
    public void loadCategory(Vector products,
                             String category, int index) {
        LoadedProducts loadedProducts
                = new LoadedProducts(products, category, index);
        categories.addElement(loadedProducts);
        currentCategoryName = category;
        currentCategory = index;
    }

    public String getCurrentName() {
        return currentCategoryName;
    }
    
    public int getCurrentIndex() {
        return currentCategory;
    }
    
    public void setCurrentName(String category) {
        for (int i = 0; i < categories.size(); i++) {
            LoadedProducts loadedProducts
                    = (LoadedProducts)categories.elementAt(i);
            if (loadedProducts.getCategoryName().equals(category)) {
                currentCategoryName = category;
                currentCategory = loadedProducts.getIndexNumber();
            }
        }
    }
    
    public void setCurrentIndex(int index) {
        for (int i = 0; i < categories.size(); i++) {
            LoadedProducts loadedProducts
                    = (LoadedProducts)categories.elementAt(i);
            if (loadedProducts.getIndexNumber() == index) {
                currentCategoryName = loadedProducts.getCategoryName();
                currentCategory = index;
            }
        }
    }
    
    public boolean isCurrent(String category) {
        return currentCategoryName.equals(category);
    }
    
    public boolean isCurrent(int index) {
        return currentCategory == index;
    }
    
    public boolean isLoaded(String category) {
        for (int i = 0; i < categories.size(); i++) {
            LoadedProducts loadedProducts
                    = (LoadedProducts)categories.elementAt(i);
            if (loadedProducts.getCategoryName().equals(category))
                return true;
        }
        return false;
    }
    
    public boolean isLoaded(int index) {
        for (int i = 0; i < categories.size(); i++) {
            LoadedProducts loadedProducts
                    = (LoadedProducts)categories.elementAt(i);
            if (loadedProducts.getIndexNumber() == index)
                return true;
        }
        return false;
    }
    
    public LoadedProducts getLoadedCategory(String category) {
        for (int i = 0; i < categories.size(); i++) {
            LoadedProducts loadedProducts
                    = (LoadedProducts)categories.elementAt(i);
            if (loadedProducts.getCategoryName().equals(category))
                return loadedProducts;
        }
        return null;
    }

    public LoadedProducts getLoadedCategory(int index) {
        for (int i = 0; i < categories.size(); i++) {
            LoadedProducts loadedProducts
                    = (LoadedProducts)categories.elementAt(i);
            if (loadedProducts.getIndexNumber() == index)
                return loadedProducts;
        }
        return null;
    }

    public String getProductID(String item) {
        String id = "";
        for (int i = 0; i < categories.size(); i++) {
            LoadedProducts loadedProducts
                    = (LoadedProducts)categories.elementAt(i);
            id = loadedProducts.getProductID(item);
            if (!id.equals(""))
                break;
        }
        return id;
    }
}
