import java.util.*;
import java.io.*;
import java.net.*;


public class JoeHTML
    implements ServerCommon, ShopCommon {
    private final String cgiAgent = "joeserv.exe";

	public JoeHTML () {
	}

    static public void main(String args[]) {
        JoeHTML proxy = new JoeHTML();
        if (args.length == 0) {
            proxy.processQueryString("");
        } else {
            proxy.processQueryString(args[0]);
        }
    }

    protected void processQueryString(String queryString) {
        /*
        System.out.println("<p><center>");
        System.out.println("CGI query string : " + queryString);
        System.out.println("</center></p>");
        */

    	QueryParser parser = new QueryParser(queryString, "&", "=");
        LookupTable table = parser.parse();

        /*
        String[] names = table.getNames();
        String[] values = table.getValues();
        System.out.println("<p><center>");
        if (names.length > 0) {
            System.out.println("<caption>User Input</caption>");
            System.out.println("<table border><tr><th>Name</th><th>Value(s)</th></tr>");
            for (int i = 0; i < names.length; i++) {
                String name = names[i];
                System.out.println("  <tr>");
                System.out.println("    <td>" + name + "</td>");
                if (table.numValues(name) > 1) {
                    String[] fullValue = table.getFullValue(name);
                    System.out.println("    <td><i>multiple values</i>");
                    System.out.println("      <ul>");
                    for (int j = 0; j < fullValue.length; j++)
                        System.out.println("        <li>" + fullValue[j]);
                    System.out.println("      </ul>");
                    System.out.println("    </td>");
                } else {
                    String value = values[i];
                    if (value.equals(""))
                        System.out.println("    <td><i>none</i></td>");
                    else
                        System.out.println("    <td>" + value + "</td>");
                }
                System.out.println("  </tr>");
            }
            System.out.println("</table>");
        } else {
            System.out.println("<h3>No User Input</h3>");
        }
        System.out.println("</center></p>");
        */

        String function = table.getValue("function");
        
        if (function == null) {
            generateHTMLshop("", 0, 0, new Vector(), "");
        } else if (function.equals("shop")) {
            String category = table.getValue("category");
            String pick = table.getValue("pick");
            int picked = 0;
            try {
                picked = Integer.parseInt(pick);
            } catch (Exception e) {
            }
            String unpick = table.getValue("unpick");
            int unpicked = 0;
            try {
                unpicked = Integer.parseInt(unpick);
            } catch (Exception e) {
            }
            String shoppingContent = table.getValue("shoppingCart");
            Vector shoppingCart = new Vector();
            if (shoppingContent != null) {
                StringTokenizer tok = new StringTokenizer(shoppingContent, "~");
                while (tok.hasMoreTokens()) {
                    shoppingCart.addElement(tok.nextToken());
                }
            }
        
            String chooseCategory = table.getValue("categoryPick");
            String addProduct = table.getValue("addButton");
            String removeProduct = table.getValue("removeButton");
            String done = table.getValue("doneButton");
            String cancel = table.getValue("cancelButton");
            
            if (chooseCategory != null) {
                generateHTMLshop(category, picked, unpicked, shoppingCart, "change");
            } else if (addProduct != null) {
                generateHTMLshop(category, picked, unpicked, shoppingCart, "add");
            } else if (removeProduct != null) {
                generateHTMLshop(category, picked, unpicked, shoppingCart, "remove");
            } else {
                generateHTMLshop(category, 0, 0, new Vector(), "");
            }
        } else {
            generateHTMLfail();
        }
	}
	
	private void generateHTMLfail() {
        System.out.println("HTTP/1.0 200 OK");
        System.out.println("Content-Type: text/html");
        System.out.println("");
        
        System.out.println("<html>");
        System.out.println("<body>");
        System.out.println("<center>");
        System.out.println("<h3>Internal Error!</h3>");
        System.out.println("</center>");
        System.out.println("</body>");
        System.out.println("</html>");
	}
	
    private void generateHTMLshop(String category, int picked, int unpicked, Vector shoppingCart, String request) {
        System.out.println("HTTP/1.0 200 OK");
        System.out.println("Content-Type: text/html");
        System.out.println("");
        
        System.out.println("<html>");
        System.out.println("<body>");
        System.out.println("<form name=\"shop\" action=\"" + cgiAgent + "\" method=\"get\" enctype=\"application/x-www-form-urlencoded\" >");
        System.out.println("<input type=\"hidden\" name=\"function\" value=\"shop\">");
        System.out.println("<center>");
        System.out.println("<table border=\"0\">");
        System.out.println("<tr><td width=\"40%\">");
        System.out.println("<b>Mechandise</b>");
        System.out.println("</td><td>");
        System.out.println("</td><td width=\"40%\">");
        System.out.println("<b>Shopping Cart</b>");
        System.out.println("</td></tr>");
        System.out.println("<tr>");
        
        System.out.println("<td valign=\"top\">");
        int categoryIndex = 0, productIndex = 0;
        Vector categoryList = getCategory();
        Vector productList = new Vector();
        for (categoryIndex = 0; categoryIndex < categoryList.size(); categoryIndex++) {
            if (((String)(categoryList.elementAt(categoryIndex))).equals(category)) {
                productList = getList(category);
                if (request.equals("change")) {
                    productIndex = 0;
                } else {
                    productIndex = picked;
                }
                break;
            }
        }
        if (categoryIndex == categoryList.size()) {
            categoryIndex = 0;
            productList = getList((String)(categoryList.elementAt(categoryIndex)));
            productIndex = 0;
        }
        System.out.println("<select name=\"category\" size=\"1\">");
        for (int i = 0; i < categoryList.size(); i++) {
            String categoryName = (String)(categoryList.elementAt(i));
            if (i == categoryIndex) {
                System.out.println("<option value=\"" + categoryName + "\" selected>" + categoryName);
            } else {
                System.out.println("<option value=\"" + categoryName + "\">" + categoryName);
            }
        }
        System.out.println("</select>");
        System.out.println("<input type=\"submit\" name=\"categoryPick\" value=\"Go\">");
        System.out.println("<p>");
        for (int i = 0; i < productList.size(); i++) {
            String productName = (String)(productList.elementAt(i));
            if (i == productIndex) {
                System.out.println("<input type=\"radio\" name=\"pick\" value=\"" + i + "\" checked>" + productName + "<br>");
            } else {
                System.out.println("<input type=\"radio\" name=\"pick\" value=\"" + i + "\">" + productName + "<br>");
            }
        }
        System.out.println("</td>");
        
        System.out.println("<td align=\"center\">");
        System.out.println("<input type=\"submit\" name=\"addButton\" value=\"&gt;&gt;\"><p>");
        System.out.println("<input type=\"submit\" name=\"removeButton\" value=\"&lt;&lt;\">");
        System.out.println("</td>");
        
        System.out.println("<td valign=\"top\">");
        if (request.equals("add")) {
            shoppingCart.addElement((productList.elementAt(picked)));
            unpicked = shoppingCart.size() - 1;
        }
        if (request.equals("remove")) {
            shoppingCart.removeElementAt(unpicked);
    		int last = shoppingCart.size() - 1;
    		if (unpicked >= last)
	    	    unpicked = last;
        }
        StringBuffer shoppingContent = new StringBuffer();
        for (int i = 0; i < shoppingCart.size(); i++) {
            if (i != 0)
                shoppingContent.append("~");
            shoppingContent.append((String)(shoppingCart.elementAt(i)));
        }
        System.out.println("<input type=\"hidden\" name=\"shoppingCart\" value=\"" + shoppingContent.toString() + "\">");
        for (int i = 0; i < shoppingCart.size(); i++) {
            String productName = (String)(shoppingCart.elementAt(i));
            if (i == unpicked) {
                System.out.println("<input type=\"radio\" name=\"unpick\" value=\"" + i + "\" checked>" + productName + "<br>");
            } else {
                System.out.println("<input type=\"radio\" name=\"unpick\" value=\"" + i + "\">" + productName + "<br>");
            }
        }
        System.out.println("</td>");
        System.out.println("</tr>");
        
        System.out.println("</table>");
        System.out.println("</center>");
        System.out.println("</form>");
        System.out.println("</body>");
        System.out.println("</html>");
    }
    
    
    private Vector getCategory() {
        Vector categoryList = new Vector();
		try {
		    Socket s = new Socket(serverHost, serverPort);
		    InputStream is = s.getInputStream();
		    BufferedReader in = new BufferedReader(
		            new InputStreamReader(is));
		    OutputStream os = s.getOutputStream();
		    PrintWriter out = new PrintWriter(
		            new OutputStreamWriter(os));
    		try {
    		    out.println(shopID);
    		    out.println("get category");
    		    out.flush();

        		String line = in.readLine();
    		    while (!line.equals("the end")) {
                    if (line != null) {
                		categoryList.addElement(line);
                	}
                	line = in.readLine();
                }
    		} catch (Exception e) {
    		}
		    in.close();
		    out.close();
		    s.close();
		} catch (Exception e) {
		}
		return categoryList;
    }
    
    private Vector getList(String category) {
        Vector productList = new Vector();
		try {
		    Socket s = new Socket(serverHost, serverPort);
		    InputStream is = s.getInputStream();
		    BufferedReader in = new BufferedReader(
		            new InputStreamReader(is));
		    OutputStream os = s.getOutputStream();
		    PrintWriter out = new PrintWriter(
		            new OutputStreamWriter(os));
    		try {
    		    out.println(shopID);
    		    out.println("get list");
    		    out.println(category);
    		    out.flush();
        		
        		String line;
    		    while ((line = in.readLine()) == null);
                ObjectInputStream ii = new ObjectInputStream(is);
                for (int i = 0; i < Integer.parseInt(line); i++) {
                    Product product = new Product();
                    product.readObject(ii);
                    out.println(i);
                    out.flush();
               		productList.addElement(product.getItem());
                }
    		} catch (Exception e) {
    		}
		    in.close();
		    out.close();
		    s.close();
		} catch (Exception e) {
		}
		return productList;
    }
}


class QueryParser {
    private String data, delims1, delims2;
    private String[] nameArray, valueArray;
    private String[][] fullValueArray;
    
    public QueryParser(String data, String delims1, String delims2) {
        this.data = data;
        this.delims1 = delims1;
        this.delims2 = delims2;
    }
    
    public LookupTable parse() {
        StringVector nameVector = new StringVector();
        Vector valueVector = new Vector();
        if (data == null)
            return buildTable(nameVector, valueVector, 0);
        StringTokenizer tok = new StringTokenizer(data, delims1);
        String nameValuePair, name, value;
        StringTokenizer tempTok;
        int index, numNames = 0;
        StringVector values;
        while (tok.hasMoreTokens()) {
            nameValuePair = tok.nextToken();
            tempTok = new StringTokenizer(nameValuePair, delims2);
            name = URLDecoder.decode(tempTok.nextToken());
            if (tempTok.hasMoreTokens())
                value = URLDecoder.decode(tempTok.nextToken());
            else
                value = "";
            index = nameVector.indexOf(name);
            if (index == -1) {
                nameVector.addElement(name);
                values = new StringVector();
                values.addElement(value);
                valueVector.addElement(values);
                numNames++;
            } else {
                values = (StringVector)valueVector.elementAt(index);
                values.addElement(value);
            }
        }
        return buildTable(nameVector, valueVector, numNames);
    }
    
    private LookupTable buildTable(StringVector nameVector,Vector valueVector, int numNames) {
        nameArray = new String[numNames];
        valueArray = new String[numNames];
        fullValueArray = new String[numNames][];
        LookupTable table = new LookupTable(nameArray, valueArray, fullValueArray);
        String[] fullValues;
        StringVector values;
        for (int i = 0; i < nameVector.size(); i++) {
            nameArray[i] = nameVector.elementAt(i);
            values = (StringVector)valueVector.elementAt(i);
            valueArray[i] = values.firstElement();
            fullValues = new String[values.size()];
            values.copyInto(fullValues);
            fullValueArray[i] = fullValues;
        }
        return table;
    }
}

class StringVector implements Cloneable {
    protected Vector vector;
    
    protected StringVector(Vector v) {
        vector = v;
    }
    
    public StringVector() {
        vector = new Vector();
    }
    
    public StringVector(int initialCapacity) {
        vector = new Vector(initialCapacity);
    }
    
    public StringVector(int initialCapacity, int capacityIncrement) {
        vector = new Vector(initialCapacity, capacityIncrement);
    }
    
    public void addElement(String string) {
        vector.addElement(string);
    }
    
    public int capacity() {
        return vector.capacity();
    }
    
    public Object clone() {
        System.out.println("Orig capacity: " + vector.capacity());
        Vector newVector = (Vector)vector.clone();
        System.out.println("New capacity: " + newVector.capacity());
        StringVector newStringVector = new StringVector();
        newStringVector.vector = newVector;
        return newStringVector;
    }
    
    public boolean contains(String string) {
        return vector.contains(string);
    }
    
    public void copyInto(String[] strings) {
        vector.copyInto(strings);
    }
    
    public String elementAt(int index) {
        return (String)vector.elementAt(index);
    }
    
    public Enumeration elements() {
        return vector.elements();
    }
    
    public void ensureCapacity(int minCapacity) {
        vector.ensureCapacity(minCapacity);
    }
    
    public String firstElement() {
        return (String)vector.firstElement();
    }
    
    public int indexOf(String string) {
        return vector.indexOf(string);
    }
    
    public int indexOf(String string, int startIndex) {
        return vector.indexOf(string, startIndex);
    }
    
    public void insertElementAt(String string, int index) {
        vector.insertElementAt(string, index);
    }
    
    public boolean isEmpty() {
        return vector.isEmpty();
    }
    
    public String lastElement() {
        return (String)vector.lastElement();
    }
    
    public int lastIndexOf(String string) {
        return vector.lastIndexOf(string);
    }
    
    public int lastIndexOf(String string, int endIndex) {
        return vector.lastIndexOf(string, endIndex);
    }
    
    public void removeAllElements() {
        vector.removeAllElements();
    }
    
    public boolean removeElement(String string) {
        return vector.removeElement(string);
    }
    
    public void removeElementAt(int index) {
        vector.removeElementAt(index);
    }
    
    public void setElementAt(String string, int index) {
        vector.setElementAt(string, index);
    }
    
    public void setSize(int size) {
        vector.setSize(size);
    }
    
    public int size() {
        return vector.size();
    }
    
    public String toString() {
        return vector.toString();
    }
    
    public void trimToSize() {
        vector.trimToSize();
    }
}

class URLDecoder {
    public static String decode(String encoded) {
        StringBuffer decoded = new StringBuffer();
        int i = 0;
        String charCode;
        char currentChar, decodedChar;
        while (i < encoded.length()) {
            currentChar = encoded.charAt(i);
            switch (currentChar) {
            case '+':
                decoded.append(" ");
                break;
            case '%':
                charCode = encoded.substring(i + 1, i + 3);
                decodedChar = (char)Integer.parseInt(charCode, 16);
                decoded.append(String.valueOf(decodedChar));
                i += 2;
                break;
            default:
                decoded.append(String.valueOf(currentChar));
            }
            i++;
        }
        return decoded.toString();
    }
}

class LookupTable {
    private String[] nameArray, valueArray;
    private String[][] fullValueArray;
    
    public LookupTable(String[] nameArray, String[] valueArray, String[][] fullValueArray) {
        this.nameArray = nameArray;
        this.valueArray = valueArray;
        this.fullValueArray = fullValueArray;
    }
    
    public String[] getNames() {
        return nameArray;
    }
    
    public String[] getValues() {
        return valueArray;
    }
    
    public String[][] getFullValues() {
        return fullValueArray;
    }
    
    public String getValue(String name) {
        for (int i = 0; i < nameArray.length; i++)
            if (nameArray[i].equals(name))
                return valueArray[i];
        return null;
    }
    
    public String[] getFullValue(String name) {
        for (int i = 0; i < nameArray.length; i++)
            if (nameArray[i].equals(name))
                return fullValueArray[i];
        return null;
    }
 
    public int numValues(String name) {
        String[] values = getFullValue(name);
        if (values == null)
            return 0;
        else
            return values.length;
    }
}
