import java.applet.Applet;
import java.awt.*;
import java.io.*;
import java.net.*;
import java.util.*;


public class JoeApplet extends Applet
        implements ServerCommon, ShopCommon {
	//{{DECLARE_CONTROLS
	java.awt.Label prodLabel;
	java.awt.Choice prodCategory;
	java.awt.List prodList;
	java.awt.Button addButton;
	java.awt.Button removeButton;
	java.awt.Label cartLabel;
	java.awt.List shoppingCart;
	//}}

	private LoadedCategories loadedCategories = new LoadedCategories();

	public void init() {
		//{{INIT_CONTROLS
		setLayout(null);
		setSize(460,246);
		prodLabel = new java.awt.Label("Merchandise");
		prodLabel.setBounds(64,0,132,26);
		prodLabel.setFont(new Font("Dialog", Font.BOLD, 12));
		add(prodLabel);
		prodCategory = new java.awt.Choice();
		add(prodCategory);
		prodCategory.setBounds(52,36,132,24);
		prodList = new java.awt.List(4);
		add(prodList);
		prodList.setBounds(52,84,132,108);
		addButton = new java.awt.Button();
		addButton.setLabel(">>");
		addButton.setBounds(252,36,36,24);
		addButton.setFont(new Font("Dialog", Font.PLAIN, 18));
		addButton.setBackground(new Color(12632256));
		add(addButton);
		removeButton = new java.awt.Button();
		removeButton.setLabel("<<");
		removeButton.setBounds(252,168,36,24);
		removeButton.setFont(new Font("Dialog", Font.PLAIN, 18));
		removeButton.setBackground(new Color(12632256));
		add(removeButton);
		cartLabel = new java.awt.Label("Shopping Cart");
		cartLabel.setBounds(312,0,132,24);
		cartLabel.setFont(new Font("Dialog", Font.BOLD, 12));
		add(cartLabel);
		shoppingCart = new java.awt.List(4);
		add(shoppingCart);
		shoppingCart.setBounds(300,36,132,156);
		//}}

		//{{REGISTER_LISTENERS
		SymItem lSymItem = new SymItem();
		prodCategory.addItemListener(lSymItem);
		SymAction lSymAction = new SymAction();
		addButton.addActionListener(lSymAction);
		removeButton.addActionListener(lSymAction);
		//}}
		
        prodCategory.removeAll();
        prodList.removeAll();
		shoppingCart.removeAll();
		getCategory();
        if (prodCategory.getItemCount() > 0) {
    		prodCategory.select(0);
    		getList(prodCategory.getItem(0));
    	}
	}

	class SymItem implements java.awt.event.ItemListener {
		public void itemStateChanged(java.awt.event.ItemEvent event) {
			Object object = event.getSource();
			if (object == prodCategory)
				prodCategory_ItemStateChanged(event);
		}
	}

	void prodCategory_ItemStateChanged(java.awt.event.ItemEvent event) {
		String category = prodCategory.getSelectedItem();
		if (!getList(category))
		    return;
	}

	class SymAction implements java.awt.event.ActionListener {
		public void actionPerformed(java.awt.event.ActionEvent event) {
			Object object = event.getSource();
			if (object == addButton)
				addButton_ActionPerformed(event);
			else if (object == removeButton)
				removeButton_ActionPerformed(event);
		}
	}

	void addButton_ActionPerformed(java.awt.event.ActionEvent event) {
		int index = prodList.getSelectedIndex();
		if (index < 0)
		    return;
		shoppingCart.addItem(prodList.getSelectedItem());
		shoppingCart.select(shoppingCart.getItemCount() - 1);
	}

	void removeButton_ActionPerformed(java.awt.event.ActionEvent event) {
		int index = shoppingCart.getSelectedIndex();
		if (index < 0)
		    return;
		shoppingCart.delItem(index);
		int last = shoppingCart.getItemCount() - 1;
		if (index < last)
		    shoppingCart.select(index);
		else
		    shoppingCart.select(last);
	}

    private boolean getCategory() {
        boolean success = true;
		try {
		    Socket s = new Socket(getDocumentBase().getHost(), serverPort);
		    BufferedReader in = new BufferedReader(
		            new InputStreamReader(s.getInputStream()));
		    PrintWriter out = new PrintWriter(
		            new OutputStreamWriter(s.getOutputStream()));
    		try {
    		    out.println(shopID);
    		    out.println("get category");
    		    out.flush();

        		String line = in.readLine();
    		    while (!line.equals("the end")) {
                    if (line != null) {
                		prodCategory.addItem(line);
                	}
                	line = in.readLine();
                }
    		} catch (Exception e) {
                success = false;
    		}
		    in.close();
		    out.close();
		    s.close();
		} catch (Exception e) {
            success = false;
		}
		return success;
    }

    private boolean getList(String category) {
        boolean success = true;
        LoadedProducts loadedProducts
                = loadedCategories.getLoadedCategory(category);
        if (loadedProducts != null) {
            if (!loadedCategories.isCurrent(category)) {
                loadedCategories.setCurrentName(category);
        		prodList.removeAll();
        		Vector products = loadedProducts.getProducts();
        		for (int i = 0; i < products.size(); i++)
                    prodList.addItem(
                            ((Product)(products.elementAt(i))).getItem());
    			prodList.select(0);
            }
            return true;
        }
		prodList.removeAll();
		try {
		    Socket s = new Socket(getDocumentBase().getHost(), serverPort);
		    InputStream is = s.getInputStream();
		    BufferedReader in = new BufferedReader(
		            new InputStreamReader(is));
		    OutputStream os = s.getOutputStream();
		    PrintWriter out = new PrintWriter(
		            new OutputStreamWriter(os));
    		try {
    		    out.println(shopID);
    		    out.println("get list");
    		    out.println(category);
    		    out.flush();

        		String line;
    		    while ((line = in.readLine()) == null);
                ObjectInputStream ii = new ObjectInputStream(is);
                Vector loadingProducts = new Vector();
                for (int i = 0; i < Integer.parseInt(line); i++) {
                    Product product = new Product();
                    product.readObject(ii);
                    out.println(i);
                    out.flush();
                    loadingProducts.addElement(product);
               		prodList.addItem(product.getItem());
                }
                loadedCategories.loadCategory(
                        loadingProducts, category,
                        prodCategory.getSelectedIndex());
    			prodList.select(0);
    		} catch (Exception e) {
    		    success = false;
    		}
		    in.close();
		    out.close();
		    s.close();
		} catch (Exception e) {
		    success = false;
		}
		return success;
    }
}
