public class DNSClient {
//
// constants of results
//

    public static final int READY = 1;
    public static final int TAKEN = 0;
    public static final int ERROR = -1;

//
// data members
//

    private static final String HOST = "www.internic.com";
    private static final int PORT = 80;
    private static final String REQUEST = "POST /cgi-bin/nwhois HTTP/1.0";
    private static final String READYPROMPT = "DOMAIN NAME AVAILABLE";
    private static final String TAKENPROMPT = "DOMAIN NAME TAKEN";
    private java.net.Socket client;

//
// public constructor and interfaces
//

    public DNSClient() {
        client = null;
    }

    public int query(String domain, String root) {
        int result = ERROR;
        if (checkHost(HOST)) {
            client = connect();
            if (client != null) {
                try {
                    result = request(domain, root);
                    client.close();
                    client = null;
                } catch (java.io.IOException e) {
                }
            }
        }
        return result;
    }

//
// internal functions
//

    protected boolean checkHost(String host) {
        try {
            java.net.InetAddress.getByName(host);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    protected java.net.Socket connect() {
        try {
            return new java.net.Socket(HOST, PORT);
        } catch(Exception e) {
            return null;
        }
    }

    protected java.io.DataInputStream getUnbufferedDataStream()
            throws java.io.IOException {
        return new java.io.DataInputStream(client.getInputStream());
    }

    protected java.io.PrintStream getPrintStream()
            throws java.io.IOException {
        return new java.io.PrintStream(client.getOutputStream());
    }

    protected int request(String domain, String root) {
        int result = ERROR;
        try {
            // get streams
            java.io.PrintStream out = getPrintStream();
            java.io.DataInputStream in = getUnbufferedDataStream();

            // output request
            String queryString = "domain=" + domain + "&root=" + root;
            String headers = "Content-Length: " + queryString.length();
            out.println(REQUEST);
            out.println(headers);
            out.println();
            out.print(queryString);
            out.flush();

            // input html in-feed
            String line;
            while ((line = in.readLine()) != null) {
                if (line.indexOf(READYPROMPT) != -1) {
                    result = READY;
                    break;
                } else if (line.indexOf(TAKENPROMPT) != -1) {
                    result = TAKEN;
                    break;
                }
            }
            out.close();
            in.close();
        } catch(Exception e) {
        }
        return result;
    }

//
// usage sample
//

    public static void main(String[] args) {
        // get parameters
        if (args.length == 0) {
            System.out.println("Usage:\n\treggie <list1> [<list2> [com|net|org]]\n");
            System.out.println("Note:\n\tLists are separated by forward slash.\n");
            System.exit(1);
        }
        String root = "com";            // default root name
        if (args.length > 2) {
            root = args[2];
        }
        java.util.StringTokenizer tok;
        java.util.Vector d1 = new java.util.Vector();
        java.util.Vector d2 = new java.util.Vector();
        String domain1, domain2;
        domain1 = args[0];
        tok = new java.util.StringTokenizer(domain1, "/");
        while (tok.hasMoreTokens()) {
            String seg = tok.nextToken();
            if (seg != null) {
                d1.addElement(seg);
            }
        }
        if (args.length > 1) {
            domain2 = args[1];
            tok = new java.util.StringTokenizer(domain2, "/");
            while (tok.hasMoreTokens()) {
                String seg = tok.nextToken();
                if (seg != null) {
                    d2.addElement(seg);
                }
            }
        } else {
            d2.addElement("");
        }

        // query domain name availability
        for (int i = 0; i < d1.size(); i++) {
            for (int j = 0; j < d2.size(); j++) {
                String domain = (String)d1.elementAt(i) + (String)d2.elementAt(j);
                System.out.print("Domain name <" + domain + "." + root + ">");
                DNSClient c = new DNSClient();
                int r = c.query(domain, root);
                switch (r) {
                case DNSClient.READY:
                    // do something
                    System.out.println(" is available.");
                    break;
                case DNSClient.TAKEN:
                    // do something
                    System.out.println(" is taken.");
                    break;
                default:
                    // do something
                    System.out.println("'s status cannot be decided.");
                    break;
                }
            }
        }
    }
}
