import java.awt.*;
import java.awt.event.*;


public class ReaderDialog extends Dialog implements Runnable {
    java.awt.Label canvas1;
    java.awt.Label label1;
    java.awt.Label label2;
    java.awt.Choice choice1;
    java.awt.TextArea textArea1;

    // Used for addNotify check.
    boolean fComponentsAdjusted = false;
    
    // application specific variables
    final int DORMANT_MINUTE = 5;
    boolean finished = false;
    private boolean flip = true;
    private POP3Reader r = new POP3Reader();
    private int mailCount = 0;

    public ReaderDialog(Frame parent, boolean modal, String host, String login, String password, String title) {
        super(parent, modal);

        setLayout(null);
        setVisible(false);
        setSize(440,420);
        setFont(new Font("Dialog", Font.PLAIN, 12));
        setForeground(new Color(0));
        setBackground(new Color(65280));
        canvas1 = new java.awt.Label("Mail Pad",Label.CENTER);
        canvas1.setBounds(20,9,402,50);
        canvas1.setFont(new Font("Dialog", Font.PLAIN, 20));
        canvas1.setForeground(new Color(16711680));
        add(canvas1);
        label1 = new java.awt.Label("Index:");
        label1.setBounds(13,69,101,25);
        label1.setFont(new Font("Dialog", Font.BOLD, 16));
        label1.setForeground(new Color(255));
        add(label1);
        label2 = new java.awt.Label("Message:");
        label2.setBounds(13,96,101,25);
        label2.setFont(new Font("Dialog", Font.BOLD, 16));
        label2.setForeground(new Color(255));
        add(label2);
        choice1 = new java.awt.Choice();
        choice1.setBounds(131,69,296,25);
        choice1.setFont(new Font("Dialog", Font.PLAIN, 14));
        choice1.setBackground(new Color(16777215));
        add(choice1);
        textArea1 = new java.awt.TextArea();
        textArea1.setBounds(15,130,412,280);
        textArea1.setFont(new Font("Dialog", Font.PLAIN, 14));
        textArea1.setBackground(new Color(16777215));
        textArea1.setEditable(false);
        add(textArea1);
        setTitle(title);

        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymItem lSymItem = new SymItem();
        choice1.addItemListener(lSymItem);
        
        r.setHost(host);
        r.setUser(login);
        r.setPassword(password);
        if (!r.login()) return;
        mailCount = r.retrieveMail();
        for (int i = mailCount; i > 0; i--) {
            choice1.addItem(String.valueOf(i));
        }
        if (mailCount > 0) {
            choice1.select(0);
            showMessage(r.retrieveMail(mailCount));
        }
    }

    public ReaderDialog(Frame parent, boolean modal, String host, String login, String password) {
        this(parent, modal, host, login, password, "Read");
    }

    public void addNotify() {
        // Record the size of the window prior to calling parents addNotify.
        Dimension d = getSize();
        
        super.addNotify();

        // Only do this once.
        if (fComponentsAdjusted) return;

        // Adjust components according to the insets
        setSize(insets().left + insets().right + d.width, insets().top + insets().bottom + d.height);
        Component components[] = getComponents();
        for (int i = 0; i < components.length; i++) {
            Point p = components[i].getLocation();
            p.translate(insets().left, insets().top);
            components[i].setLocation(p);
        }

        // Used for addNotify check.
        fComponentsAdjusted = true;
    }

    public void setVisible(boolean b) {
        if(b) {
            Rectangle bounds = getParent().getBounds();
            Rectangle abounds = getBounds();
    
            int locx = bounds.x + (bounds.width - abounds.width) / 2;
            int locy = bounds.y + (bounds.height - abounds.height) / 2;
            if (locx < 0) locx = 20;
            if (locy < 0) locy = 20;
            setLocation(locx, locy);
        }
        super.setVisible(b);
    }

    class SymWindow extends java.awt.event.WindowAdapter {
        public void windowClosing(java.awt.event.WindowEvent event) {
            Object object = event.getSource();
            if (object == ReaderDialog.this) {
                finished = true;
                r.logout();
                ReaderDialog_WindowClosing(event);
            }
        }
    }

    void ReaderDialog_WindowClosing(java.awt.event.WindowEvent event) {
        dispose();
    }

    class SymItem implements java.awt.event.ItemListener {
        public void itemStateChanged(java.awt.event.ItemEvent event) {
            Object object = event.getSource();
            if (object == choice1) {
                choice1_ItemStateChanged(event);
            }
        }
    }

    synchronized void choice1_ItemStateChanged(java.awt.event.ItemEvent event) {
        try {
            if (choice1.getSelectedIndex() == -1) return;
            int index = Integer.parseInt(choice1.getSelectedItem());
            showMessage(r.retrieveMail(index));
        } catch(Exception e) {
        }
    }
    
    void showMessage(String m) {
        String mdisp = "";
        if (m != null) {
            int lineB = -1;
            int lineE = m.indexOf('\n', lineB + 1);
            boolean head = true;
            while (lineE != -1) {
                String line;
                if (m.charAt(lineE - 1) == '\r') {
                    line = m.substring(lineB + 1, lineE - 1);
                } else {
                    line = m.substring(lineB + 1, lineE);
                }
                if (head) {
                    if (line.startsWith("From:") ||
                        line.startsWith("Date:") ||
                        line.startsWith("Subject:")) {
                        mdisp += line + "\n";
                    } else if (line.equals("")) {
                        head = false;
                        mdisp += "\n";
                    }
                } else {
                    mdisp += line + "\n";
                }
                lineB = lineE;
                lineE = m.indexOf('\n', lineB + 1);
            }
        }
        textArea1.setText(mdisp);
    }

    public void run() {
        try {
            while (!finished) {
                Thread.currentThread().sleep(DORMANT_MINUTE * 60 * 1000);
                int mailc = r.retrieveMail();
                if (mailc > mailCount) {
                    for (int i = mailCount + 1; i <= mailc; i++) {
                        choice1.insert(String.valueOf(i), 0);
                    }
                    mailCount = mailc;
                    choice1.select(0);
                    textArea1.setText("NEW MESSAGE(S)!");
                }
            }
        } catch (Exception e) {
        }
    }
}
