import java.io.*;
import java.net.*;
import java.util.*;


public class POP3Reader extends Thread {
    // variables
    protected Socket popSocket;
    protected BufferedReader popIn;
    protected PrintWriter popOut;
    protected String lastInputLine = "";
    protected boolean popDebug;
    protected boolean popDelete;
    protected String popHost;
    protected int popPort;
    protected String popUser;
    protected String popPassword;
    protected int popMessageCount;
    protected Vector messages;

    // constructor
    public POP3Reader() {
        popDebug = false;
        popDelete = false;
        popHost = null;
        popPort = 110;
        popUser = null;
        popPassword = null;
        popMessageCount = 0;
    }

    // accessors
    public void setPort(int port) {
        popPort = port;
    }
    public int getPort() {
        return popPort;
    }
    public void setHost(String host) {
        popHost = host;
    }
    public String getHost() {
        return popHost;
    }
    public void setUser(String user) {
        popUser = user;
    }
    public String getUser() {
        return popUser;
    }
    public void setPassword(String password) {
        popPassword = password;
    }
    public String getPassword() {
        return popPassword;
    }
    public void setDebug(boolean debug) {
        popDebug = debug;
    }
    public boolean getDebug() {
        return popDebug;
    }
    public void setDelete(boolean delete) {
        popDelete = delete;
    }
    public boolean getDelete() {
        return popDelete;
    }
    protected void setMessageCount(int count) {
        popMessageCount = count;
    }
    public int getMessageCount() {
        return popMessageCount;
    }
    
    // main
    public boolean login() {
        try {
            popSocket = new Socket(popHost, popPort);
            popOut = new PrintWriter(popSocket.getOutputStream(), true);
            popIn = new BufferedReader(new InputStreamReader(popSocket.getInputStream()));
            
            popOut.println("USER " + popUser);
            waitForResponse("*");
            popOut.println("PASS " + popPassword);
            waitForResponse("*");
            waitForResponse("*");
            
            return true;
        } catch (Exception e) {
            return false;
        }
    }
    public boolean logout() {
        try {
            popIn.close();
            popOut.close();
            popSocket.close();
            
            return true;
        } catch (Exception e) {
            return false;
        }
    }
    public int retrieveMail() {
        try {
            popOut.println("STAT");
            while (!waitForResponse("+OK"));
            StringTokenizer s = new StringTokenizer(lastInputLine);
            s.nextToken();
            popMessageCount = Integer.parseInt(s.nextToken());
        } catch (Exception e) {
            popMessageCount = 0;
        }
        return popMessageCount;
    }
    public String retrieveMail(int which) {
        return getMessage(which);
    }
    
    // core
    protected boolean waitForResponse(String response) {
        String nextLine;
        if (popSocket == null) return false;
        while ((nextLine = getNextLine()) != null) {
            if (response.equals("*") || nextLine.startsWith(response)) return true;
            idle();
        }
        return false;
    }
    protected String getMessage(int which) {
        String myMessage = "";
        if (popSocket == null) return null;
        popOut.println("RETR " + which);
        if (!waitForResponse("+OK")) return "Error retrieving message #" + which + ".";
        String l;
        while ((l = getNextLine()) != null) {
            if (l.equals(".")) break;
            myMessage += l + "\r\n";
        }
        if (popDelete) {
            popOut.println("DELE " + which);
            waitForResponse("*");
        }
        return myMessage;
    }
    
    // assistant
    protected void idle() {
        try {
            sleep(1000);
        } catch (InterruptedException e) {
        }
    }
    protected String getNextLine() {
        try {
            lastInputLine = popIn.readLine();
            if (popDebug) {
                System.out.println(lastInputLine);
            }
            return lastInputLine;
        } catch (Exception e) {
        }
        return null;
    }
    
    // start-up
    public static void main(String[] args) {
        POP3Reader r = new POP3Reader();
        
        //r.setDebug(true);
        
        r.setHost("shrike.depaul.edu");
        r.setUser("szhou1");
        r.setPassword("");
        
        if (!r.login()) return;
        if (args.length == 0) {
            System.out.println("There are " + r.retrieveMail() + " message(s) available.");
        } else {
            System.out.println(r.retrieveMail(Integer.parseInt(args[0])));
        }
        r.logout();
    }
}
